<?php

/**

 * The template for displaying search results pages

 *

 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result

 *

 * @package WordPress

 * @subpackage Twenty_Seventeen

 * @since 1.0

 * @version 1.0

 */



get_header(); ?>



<div class="wrap ">



	<header class="page-header container">

		<?php if ( have_posts() ) : ?>

			<h1 class="page-title heading_for_single"><?php printf( __( 'Search Results for: %s', 'twentyseventeen' ), '<span>' . get_search_query() . '</span>' ); ?></h1>

		<?php else : ?>

			<h1 class="page-title heading_for_single"><?php _e( 'Nothing Found', 'twentyseventeen' ); ?></h1>

		<?php endif; ?>

	</header><!-- .page-header -->



	<div id="primary" class="content-area">	

    

    <div class="full wrapper-ceter-section">



		<main id="main" class="site-main" role="main">

			<div class="container">

		<?php

		if ( have_posts() ) :

			/* Start the Loop */ ?> 

	<div class="posts-pagination-wrapper">

    <?php

			while ( have_posts() ) : the_post();



				/**

				 * Run the loop for the search to output the results.

				 * If you want to overload this in a child theme then include a file

				 * called content-search.php and that will be used instead.

				 */

				get_template_part( 'template-parts/post/content', 'excerpt' );



			endwhile; // End of the loop.

			?>

			<div class="pagination-bottom">

			<?php

			the_posts_pagination( array(

				'prev_text' => /*twentyseventeen_get_svg( array( 'icon' => 'arrow-left' ) ) .*/ '<span class="screen-reader-text">' . __( 'Previous', 'twentyseventeen' ) . '</span>',

				'next_text' => '<span class="screen-reader-text">' . __( 'Next', 'twentyseventeen' ) . '</span>'  /* twentyseventeen_get_svg( array( 'icon' => 'arrow-right' ) )*/,

				'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( '', 'twentyseventeen' ) . ' </span>',

			) ); ?>

            </div>

			

			</div>

			

			<?php

			



		else : ?>



			<p><?php _e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'twentyseventeen' ); ?></p>

			<?php

				///get_search_form();



		endif;

		?>

        

          <div class="right-side-bar">

            	<div class="about-us-wrapper">

                <?php

                	$about_post = get_post(6);

				?>

                	<h1><?php echo $about_post->post_title; ?></h1>

                	<div class="about-image">

                    	<img src="<?php echo get_template_directory_uri(); ?>/images/about-me.jpg" alt="bout us" />

                    	<div class="name_position">

                        	<span> </span>

                            <span style="font-size:14px;"></span>

                        </div>

                    </div>

                    <div class="about-text">

                    	<p><?php echo wp_trim_words($about_post->post_content, 70, '... <a href="'.  get_permalink($about_post->ID) .'">Read More </a>') ?></p>

                    </div>

                </div>

                <div class="ads-sec">

                	<!--<img src="<?php //echo get_template_directory_uri(); ?>/images/ads-imge.jpg" alt="ads" />-->
                	<?php dynamic_sidebar( 'Advertisment Banner' ); ?>

                </div>

                <div class="popular-posts-wrapper">

                	<h1>Popular Post</h1>

					<?php

							 $args =  new WP_Query ( array(

								'posts_per_page'   => 5,

								'post_type'        => 'post',

								'meta_key' => 'wpb_post_views_count',

								'orderby' => 'meta_value_num',

								'order' => 'DESC' 

							));

							$pop_posts = get_posts($args);

                    		foreach ( $pop_posts as $post ) : setup_postdata( $post ); 

							$Postid = $post->ID;

							$format = 'M d Y';

							$thumb_url = get_the_post_thumbnail( $Postid, 'popularpost-thumb' );

							$post_title = $post->post_title;

							$post_date = get_the_date( $format, $Postid ); 



					?>                    

                    <div class="single_post_pop">

                    	<div  class="pop_post_image">

                        	<a href="<?php echo get_permalink($Postid); ?>"><?php echo $thumb_url ?></a>

                        </div>

                        <div class="pop_post_text">

                        	<a href="<?php echo get_permalink($Postid); ?>"><?php  echo $post->post_title; ?></a>

                            <span class="date-time"><?php  echo $post_date; ?></span>

                        </div>

                        <div class="clear"></div>

                    </div>

              <?php

					$post_counter++;

                	endforeach;

					wp_reset_postdata();?>

                </div>

                <div class="subscribe-follow">

                	<h1>Subscribe & Follow</h1>

                     <?php echo wen_social_links(); ?> 

                </div>

                <div class="insta-feed">

                	<h1>Instagram Feed</h1>

	<?php  do_shortcode('[instagram-feed num=9 cols=3]'); ?>



                    <span>@thespecialwomen</span>

                </div>

                <div class="news-letter">

                	<h1>Subscribe our Newsletter</h1>

					<?php dynamic_sidebar( 'Subscription Form' ); ?> 

                </div>

                <div class="tags_all">

                	<h1>Tags</h1>

                    <?php

                    $tags = get_tags();

						$html = '<div class="post_tags"><ul>';

						foreach ( $tags as $tag ) {

							$tag_link = get_tag_link( $tag->term_id );

									 

							$html .= "<li><a href='{$tag_link}' title='{$tag->name} Tag' class='{$tag->slug}'>";

							$html .= "{$tag->name}</li></a>";

						}

						$html .= '</ul></div>';

						echo $html;

					?>

                    

                </div>

            </div>

            <div class="clear"></div>

		</div>

		</main><!-- #main -->



	</div><!-- #primary -->

	<?php //get_sidebar(); ?>

</div><!-- .wrap -->

</div>



<?php get_footer();

