<?php
/**
 * Template part for displaying posts with excerpts
 *
 * Used in Search Results and for Recent Posts in Front Page panels.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.0
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

            	<?php 
			$post_counter = 1;
			//$post = get_post(the_ID());
			$Postid = $post->ID;
			$format = 'M d Y';
			$thumb_url = get_the_post_thumbnail( $Postid, 'homepage-thumb' );
			$post_title = $post->post_title;
			$post_date = get_the_date( $format, $Postid ); 


		?>
			
            	<div class="posts-paginaion-single">
                	<div class="post-page-image">
                    	<a href="<?php echo get_permalink($Postid); ?>"><?php echo $thumb_url;  ?></a>
                    </div>
                    <div class="post-page-content">
                    	<h1><?php echo $post->post_title;  ?></h1>
                        <span class="date-time"><?php echo $post_date; ?></span>
                        <p><?php echo wp_trim_words($post->post_content, 35, '...'); ?></p>
                        <div class="read-more-and-social-links">
                        	<a class="continue-reading" href="<?php echo get_permalink($Postid); ?>">continue Reading</a>
                            <?php echo do_shortcode('[apss_share]'); ?>
                        </div>
                    </div>
                    <div class="clear"></div>
                </div>
                <?php
				
                	//if ($post_counter == 8) {
						
				?>
                <div class="nav-previous alignleft"><?php //next_posts_link( 'Older posts' ); ?></div>
                <div class="nav-next alignright"><?php //previous_posts_link( 'Newer posts' ); ?></div>
                <!--<div class="pagination-bottom">
                	<a class="active_one" href="#">1</a>
                    <a href="#">2</a>
                    <a href="#">Next</a>
                </div>-->
                <?php
					//}
				?>
              <?php
					$post_counter++;
				$args = array(
					
				);

					?>
             <!-- .entry-header -->
             

	<div class="entry-summary">
		<?php //the_excerpt(); ?>
	</div><!-- .entry-summary -->

</article><!-- #post-## -->
